/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.JICPPacket;
import jade.mtp.TransportAddress;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public class JICPConnection
extends Connection {
    protected StreamConnection sc;
    protected InputStream is;
    protected OutputStream os;

    protected JICPConnection() {
    }

    public JICPConnection(TransportAddress ta) throws IOException {
        this(ta, 0);
    }

    public JICPConnection(TransportAddress ta, int timeout) throws IOException {
        String url = "socket://" + ta.getHost() + ":" + ta.getPort();
        this.sc = (StreamConnection)Connector.open((String)url, (int)3, (boolean)false);
        this.is = this.sc.openInputStream();
        this.os = this.getOutputStream();
    }

    public JICPPacket readPacket() throws IOException {
        if (this.sc != null) {
            if (this.is == null) {
                this.is = this.sc.openInputStream();
            }
            return JICPPacket.readFrom(this.is);
        }
        throw new IOException("Connection closed");
    }

    public int writePacket(JICPPacket pkt) throws IOException {
        if (this.sc != null) {
            if (this.os == null) {
                this.os = this.getOutputStream();
            }
            int ret = pkt.writeTo(this.os);
            this.os.flush();
            return ret;
        }
        throw new IOException("Connection closed");
    }

    protected OutputStream getOutputStream() throws IOException {
        return new ByteArrayOutputStream(){
            private OutputStream realOs = null;

            public void flush() throws IOException {
                if (this.realOs == null) {
                    this.realOs = JICPConnection.this.sc.openOutputStream();
                }
                this.realOs.write(this.buf, 0, this.count);
                this.realOs.flush();
                this.reset();
            }

            public void close() throws IOException {
                super.close();
                if (this.realOs != null) {
                    this.realOs.close();
                    this.realOs = null;
                }
            }
        };
    }

    public void close() throws IOException {
        IOException firstExc = null;
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException e) {
                firstExc = e;
            }
            this.is = null;
        }
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException e) {
                firstExc = firstExc != null ? firstExc : e;
            }
            this.os = null;
        }
        if (this.sc != null) {
            try {
                this.sc.close();
            }
            catch (IOException e) {
                firstExc = firstExc != null ? firstExc : e;
            }
            this.sc = null;
        }
        if (firstExc != null) {
            throw firstExc;
        }
    }
}

